<?php
include "db.php";
$id = $_GET['id'];

$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM students WHERE id=$id"));
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="p-10 bg-gray-100">

<div class="max-w-4xl mx-auto bg-white p-8 shadow rounded">
    <!-- Header -->
    <div class="text-center mb-8">
        <h1 class="text-3xl font-bold text-blue-800">Student Profile</h1>
        <p class="text-gray-600">ID: <?= $data['id'] ?></p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
        <!-- Photo Section -->
        <div class="text-center">
            <?php if(!empty($data['photo']) && file_exists("../uploads/" . $data['photo'])): ?>
                <img src="../uploads/<?= $data['photo'] ?>"
                     alt="Student Photo"
                     class="w-48 h-48 rounded-full mx-auto border-4 border-blue-200 object-cover mb-4">
            <?php else: ?>
                <div class="w-48 h-48 bg-gray-200 rounded-full mx-auto flex items-center justify-center mb-4">
                    <span class="text-gray-500">No Photo</span>
                </div>
            <?php endif; ?>

            <div class="bg-blue-50 p-4 rounded-lg">
                <h3 class="font-bold text-blue-800">Quick Info</h3>
                <p><strong>ID:</strong> <?= $data['id'] ?></p>
                <p><strong>Class:</strong> <?= $data['class_name'] ?></p>
                <p><strong>Gender:</strong> <?= $data['gender'] ?></p>
            </div>
        </div>

        <!-- Personal Information -->
        <div class="md:col-span-2">
            <div class="bg-white border border-gray-200 rounded-lg">
                <!-- Personal Info -->
                <div class="border-b border-gray-200 p-4">
                    <h2 class="text-xl font-bold text-blue-700 mb-3">Personal Information</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div><strong>Full Name:</strong> <?= $data['full_name'] ?></div>
                        <div><strong>Date of Birth:</strong> <?= $data['dob'] ?></div>
                        <div><strong>Gender:</strong> <?= $data['gender'] ?></div>
                        <div><strong>Class:</strong> <?= $data['class_name'] ?></div>
                        <div><strong>Birth Certificate:</strong> <?= $data['birth_cert'] ?: 'N/A' ?></div>
                    </div>
                </div>

                <!-- Address Info -->
                <div class="border-b border-gray-200 p-4">
                    <h2 class="text-xl font-bold text-blue-700 mb-3">Address Information</h2>
                    <div class="space-y-2">
                        <div><strong>Present Address:</strong> <?= $data['address_present'] ?: 'N/A' ?></div>
                        <div><strong>District:</strong> <?= $data['present_district'] ?: 'N/A' ?></div>
                        <div><strong>Post Code:</strong> <?= $data['present_post_code'] ?: 'N/A' ?></div>
                        <div><strong>Permanent Address:</strong> <?= $data['address_permanent'] ?: 'N/A' ?></div>
                    </div>
                </div>

                <!-- Parents Info -->
                <div class="border-b border-gray-200 p-4">
                    <h2 class="text-xl font-bold text-blue-700 mb-3">Parents Information</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="bg-blue-50 p-3 rounded">
                            <h3 class="font-semibold text-blue-800">Father's Details</h3>
                            <p><strong>Name:</strong> <?= $data['father_name'] ?: 'N/A' ?></p>
                            <p><strong>NID:</strong> <?= $data['father_nid'] ?: 'N/A' ?></p>
                            <p><strong>Phone:</strong> <?= $data['father_phone'] ?: 'N/A' ?></p>
                        </div>
                        <div class="bg-green-50 p-3 rounded">
                            <h3 class="font-semibold text-green-800">Mother's Details</h3>
                            <p><strong>Name:</strong> <?= $data['mother_name'] ?: 'N/A' ?></p>
                            <p><strong>NID:</strong> <?= $data['mother_nid'] ?: 'N/A' ?></p>
                        </div>
                    </div>
                </div>

                <!-- Additional Info -->
                <div class="p-4">
                    <h2 class="text-xl font-bold text-blue-700 mb-3">Additional Information</h2>
                    <div class="space-y-2">
                        <div><strong>Previous School:</strong> <?= $data['previous_school'] ?: 'N/A' ?></div>
                        <div><strong>Health Information:</strong> <?= $data['health_info'] ?: 'N/A' ?></div>
                        <div><strong>Special Note:</strong> <?= $data['note'] ?: 'N/A' ?></div>
                    </div>
                </div>
            </div>

            <!-- Back Button -->
            <div class="mt-6 text-center">
                <a href="list.php"
                   class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg inline-block">
                   ← Back to Student List
                </a>
            </div>
        </div>
    </div>
</div>

</body>
</html>
