<?php
include "db.php";
$result = mysqli_query($conn, "SELECT * FROM students ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="p-10 bg-gray-100">

<h1 class="text-3xl font-bold mb-6">Student List</h1>

<table class="w-full bg-white shadow rounded">
    <tr class="bg-gray-200">
        <th class="p-3">ID</th>
        <th class="p-3">Photo</th>
        <th class="p-3">Name</th>
        <th class="p-3">Class</th>
        <th class="p-3">Father's Name</th>
        <th class="p-3">Action</th>
    </tr>

    <?php while($row = mysqli_fetch_assoc($result)) { ?>
    <tr class="border-b">
        <td class="p-3"><?= $row['id'] ?></td>
        <td class="p-3">
            <?php if(!empty($row['photo'])): ?>
                <img src="../uploads/<?= $row['photo'] ?>" width="50" class="rounded">
            <?php else: ?>
                <div class="w-10 h-10 bg-gray-300 rounded flex items-center justify-center">
                    <span class="text-gray-600">No Photo</span>
                </div>
            <?php endif; ?>
        </td>
        <td class="p-3"><?= $row['full_name'] ?></td>
        <td class="p-3"><?= $row['class_name'] ?></td>
        <td class="p-3"><?= $row['father_name'] ?></td>
        <td class="p-3">
            <a class="text-blue-600 hover:text-blue-800" href="view.php?id=<?= $row['id'] ?>">View</a>
        </td>
    </tr>
    <?php } ?>

</table>

</body>
</html>
